package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TJugglerType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "juggler")
@ParametersAreNullableByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class JugglerMethod {
    @ApiModelProperty(value = "Mustache template, by default solomon-alert")
    public String host;
    @ApiModelProperty(value = "Mustache template, by default {{alert.id}}")
    public String service;
    @ApiModelProperty(value = "Mustache template, empty by default")
    public String instance;
    @ApiModelProperty(value = "Mustache template, by default default template")
    public String description;
    @ApiModelProperty(value = "Mustache template supportable list of tags for event")
    public List<String> tags;

    static JugglerMethod fromProto(@Nonnull TJugglerType juggler) {
        JugglerMethod config = new JugglerMethod();
        config.host = juggler.getHost();
        config.service = juggler.getService();
        config.instance = juggler.getInstance();
        config.description = juggler.getDescription();
        config.tags = ImmutableList.copyOf(juggler.getTagsList());
        return config;
    }

    public TJugglerType toProto() {
        return TJugglerType.newBuilder()
                .setHost(Nullables.orEmpty(host))
                .setService(Nullables.orEmpty(service))
                .setInstance(Nullables.orEmpty(instance))
                .setDescription(Nullables.orEmpty(description))
                .addAllTags(Nullables.orEmpty(tags))
                .build();
    }
}
