package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "NotificationChannelPage", parent = TokenBasePage.class)
public class NotificationChannelList extends TokenBasePage<NotificationChannelDto> {
    public static NotificationChannelList fromProto(TListNotificationsResponse proto) {
        NotificationChannelList result = new NotificationChannelList();
        result.items = proto.getNotificationList()
                .stream()
                .map(NotificationChannelDto::fromProto)
                .collect(toList());
        result.nextPageToken = proto.getNextPageToken();
        return result;
    }
}
