package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.monitoring.api.v3.ServiceProviderResourceSeverity;
import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.Severity;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "NotificationChannelsForSeverity", parent = TokenBasePage.class)
public class NotificationChannelsForSeverityResponse {
    @ApiModelProperty(
            value = "Channels for INFO",
            position = 1)
    public List<NotificationChannelDto> channelsInfo = new ArrayList<>();

    @ApiModelProperty(
            value = "Channels for DISASTER",
            position = 2)
    public List<NotificationChannelDto> channelsDisaster = new ArrayList<>();

    @ApiModelProperty(
            value = "Channels for CRITICAL",
            position = 3)
    public List<NotificationChannelDto> channelsCritical = new ArrayList<>();

    public static NotificationChannelsForSeverityResponse fromProto(
            ServiceProviderResourceSeverity severity,
            TListNotificationsResponse response)
    {
        var dto = NotificationChannelList.fromProto(response);
        switch (severity) {
            case SERVICE_PROVIDER_RESOURCE_SEVERITY_HIGHLY_CRITICAL -> {
                return highlyCritical(dto);
            }
            case SERVICE_PROVIDER_RESOURCE_SEVERITY_CRITICAL -> {
                return critical(dto);
            }
            case SERVICE_PROVIDER_RESOURCE_SEVERITY_NON_CRITICAL -> {
                return info(dto);
            }
            default -> throw new IllegalArgumentException("Unsupported severity '" + severity + "'");
        }
    }

    private static NotificationChannelsForSeverityResponse info(NotificationChannelList dto) {
        NotificationChannelsForSeverityResponse r = new NotificationChannelsForSeverityResponse();
        for (NotificationChannelDto item : dto.items) {
            if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_INFO)) {
                r.channelsInfo.add(item);
                r.channelsDisaster.add(item);
                r.channelsCritical.add(item);
            }
        }
        return r;
    }

    private static NotificationChannelsForSeverityResponse critical(NotificationChannelList dto) {
        NotificationChannelsForSeverityResponse r = new NotificationChannelsForSeverityResponse();
        for (NotificationChannelDto item : dto.items) {
            if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_CRITICAL)) {
                r.channelsDisaster.add(item);
                r.channelsCritical.add(item);
            } else if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_INFO)) {
                r.channelsInfo.add(item);
            }
        }
        return r;
    }

    private static NotificationChannelsForSeverityResponse highlyCritical(NotificationChannelList dto) {
        NotificationChannelsForSeverityResponse r = new NotificationChannelsForSeverityResponse();
        for (NotificationChannelDto item : dto.items) {
            if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_DISASTER)) {
                r.channelsDisaster.add(item);
            } else if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_CRITICAL)) {
                r.channelsCritical.add(item);
            } else if (item.defaultForAlertSeverity.contains(Severity.SEVERITY_INFO)) {
                r.channelsInfo.add(item);
            }
        }
        return r;
    }
}
