package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TNotification;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "method", description = "Only one of the property can be specified")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotificationMethod {
    @ApiModelProperty(value = "Email specific notification channel configuration", position = 1)
    public EmailMethod email;
    @ApiModelProperty(value = "Juggler specific notification channel configuration", position = 2)
    public JugglerMethod juggler;
    @ApiModelProperty(value = "Webhook specific notification channel configuration", position = 3)
    public WebhookMethod webhook;
    @ApiModelProperty(value = "SMS specific notification channel configuration", position = 4)
    public SmsMethod sms;
    @ApiModelProperty(value = "Telegram specific notification channel configuration", position = 5)
    public TelegramMethod telegram;
    @ApiModelProperty(value = "CloudEmail specific notification channel configuration", position = 6)
    public CloudEmailMethod cloudEmail;
    @ApiModelProperty(value = "CloudSms specific notification channel configuration", position = 7)
    public CloudSmsMethod cloudSms;
    @ApiModelProperty(value = "Yandex chats specific notification channel configuration", position = 8)
    public YaChatsMethod yaChats;
    @ApiModelProperty(value = "Datalens email specific notification channel configuration", position = 9)
    public DatalensEmailMethod datalensEmail;
    @ApiModelProperty(value = "CloudPush specific notification channel configuration", position = 10)
    public CloudPushMethod cloudPush;
    @ApiModelProperty(value = "Phone specific notification channel configuration", position = 11)
    public PhoneMethod phoneCall;

    public static NotificationMethod fromProto(TNotification proto) {
        NotificationMethod method = new NotificationMethod();
        switch (proto.getTypeCase()) {
            case JUGGLER -> method.juggler = JugglerMethod.fromProto(proto.getJuggler());
            case EMAIL -> method.email = EmailMethod.fromProto(proto.getEmail());
            case WEBKOOK -> method.webhook = WebhookMethod.fromProto(proto.getWebkook());
            case PHONE -> method.phoneCall = PhoneMethod.fromProto(proto.getPhone());
            case SMS -> method.sms = SmsMethod.fromProto(proto.getSms());
            case TELEGRAM -> method.telegram = TelegramMethod.fromProto(proto.getTelegram());
            case CLOUDEMAIL -> method.cloudEmail = CloudEmailMethod.fromProto(proto.getCloudEmail());
            case CLOUDSMS -> method.cloudSms = CloudSmsMethod.fromProto(proto.getCloudSms());
            case YACHATS -> method.yaChats = YaChatsMethod.fromProto(proto.getYaChats());
            case DATALENSEMAIL ->  method.datalensEmail = DatalensEmailMethod.fromProto(proto.getDatalensEmail());
            case CLOUDPUSH -> method.cloudPush = CloudPushMethod.fromProto(proto.getCloudPush());
            default -> throw new UnsupportedOperationException("Not supported notification method " + proto.getTypeCase());
        }

        return method;
    }

    public void fillProto(@Nonnull TNotification.Builder proto) {
        if (juggler != null) {
            proto.setJuggler(juggler.toProto());
        }
        if (email != null) {
            proto.setEmail(email.toProto());
        }
        if (webhook != null) {
            proto.setWebkook(webhook.toProto());
        }
        if (phoneCall != null) {
            proto.setPhone(phoneCall.toProto());
        }
        if (sms != null) {
            proto.setSms(sms.toProto());
        }
        if (telegram != null) {
            proto.setTelegram(telegram.toProto());
        }
        if (cloudEmail != null) {
            proto.setCloudEmail(cloudEmail.toProto());
        }
        if (cloudSms != null) {
            proto.setCloudSms(cloudSms.toProto());
        }
        if (yaChats != null) {
            proto.setYaChats(yaChats.toProto());
        }
        if (datalensEmail != null) {
            proto.setDatalensEmail(datalensEmail.toProto());
        }
        if (cloudPush != null) {
            proto.setCloudPush(cloudPush.toProto());
        }
    }
}
