package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.solomon.alert.protobuf.notification.PhoneType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "phoneCall")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PhoneMethod {

    @ApiModelProperty(value = "Staff login",
            example = "alexlovkov")
    public String login;

    @ApiModelProperty(value = "Abc duty service",
            example = "solomon")
    public String abcService;

    @ApiModelProperty(value = "Abc duty slug",
            example = "sre")
    public String dutySlug;

    static PhoneMethod fromProto(@Nonnull PhoneType phoneType) {
        PhoneMethod phoneMethod = new PhoneMethod();
        if (phoneType.hasDuty()) {
            phoneMethod.dutySlug = phoneType.getDuty().getDutySlug();
            phoneMethod.abcService = phoneType.getDuty().getAbcService();
        } else {
            phoneMethod.login = phoneType.getLogin();
        }
        return phoneMethod;
    }

    public PhoneType toProto() {
        PhoneType.Builder builder = PhoneType.newBuilder();
        if (Strings.isNotEmpty(login)) {
            return builder.setLogin(login)
                    .build();
        } else {
            return builder.setDuty(PhoneType.Duty.newBuilder()
                    .setAbcService(Nullables.orEmpty(abcService))
                    .setDutySlug(Nullables.orEmpty(dutySlug))
                    .build())
                    .build();
        }
    }
}
