package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.solomon.alert.protobuf.notification.TSmsType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ApiModel(value = "sms")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SmsMethod {
    @ApiModelProperty(value = "Phone number that should receive SMS notifications",
        required = true,
        example = "+71234567890")
    public String phone;
    @ApiModelProperty(value = "User login that should receive SMS notifications, will be use default phone from passport",
            required = true,
            example = "gordiychuk")
    public String login;

    @ApiModelProperty(value = "Mustache template for SMS. It's optional parameter",
        example = "Everything is broken : {{status.code}}!")
    public String textTemplate;

    static SmsMethod fromProto(@Nonnull TSmsType sms) {
        SmsMethod config = new SmsMethod();
        config.phone = sms.getPhone();
        config.login = sms.getLogin();
        config.textTemplate = sms.getTextTemplate();
        return config;
    }

    public TSmsType toProto() {
        TSmsType.Builder builder = TSmsType.newBuilder()
                .setTextTemplate(Nullables.orEmpty(textTemplate));

        if (Strings.isNotEmpty(phone)) {
            return builder.setPhone(phone)
                    .build();
        }

        return builder.setLogin(Nullables.orEmpty(login))
                .build();
    }
}
