package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.solomon.alert.protobuf.notification.TTelegramType;
import ru.yandex.solomon.util.collection.Nullables;


/**
 * @author alexlovkov
 **/
@ApiModel(value = "telegram")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TelegramMethod {

    @ApiModelProperty(value = "Staff login",
        example = "alexlovkov")
    public String login;

    @ApiModelProperty(value = "Title of the group chat",
        example = "Solomon-Group")
    public String groupTitle;

    @ApiModelProperty(value = "Mustache template for telegram. It's optional parameter",
        example = "Everything is broken : {{status.code}}!")
    public String textTemplate;

    @ApiModelProperty(value = "True if telegram bot must send screenshot in notifications, false otherwise",
        example = "true")
    public Boolean sendScreenshot;

    static TelegramMethod fromProto(@Nonnull TTelegramType telegram) {
        TelegramMethod telegramMethod = new TelegramMethod();
        telegramMethod.login = telegram.getLogin();
        telegramMethod.groupTitle = telegram.getGroupTitle();
        telegramMethod.textTemplate = telegram.getTextTemplate();
        telegramMethod.sendScreenshot = telegram.getSendScreenshot();
        return telegramMethod;
    }

    public TTelegramType toProto() {
        TTelegramType.Builder builder = TTelegramType.newBuilder()
            .setTextTemplate(Nullables.orEmpty(textTemplate))
            .setSendScreenshot(Nullables.orFalse(sendScreenshot));

        if (Strings.isNotEmpty(login)) {
            return builder.setLogin(login)
                .build();
        }

        return builder.setGroupTitle(Nullables.orEmpty(groupTitle))
            .build();
    }
}
