package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.THeader;
import ru.yandex.solomon.alert.protobuf.notification.TWebhookType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "webhook")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WebhookMethod {
    @ApiModelProperty(value = "Url that will be use to POST request",
            required = true,
            example = "http://myhost:8181/alert")
    public String url;
    @ApiModelProperty(value = "Mustache template for body",
            example = "{\"alertId\": \"{{alert.id}}\", \"status\": \"{{status.code}}\", \"when\": \"{{since}}\"}")
    public String bodyTemplate;
    @ApiModelProperty(value = "Additional headers that need inject to notification request")
    public Map<String, String> headers = Collections.emptyMap();

    static WebhookMethod fromProto(@Nonnull TWebhookType webhook) {
        WebhookMethod config = new WebhookMethod();
        config.url = webhook.getUrl();
        config.bodyTemplate = webhook.getTemplate();
        config.headers = webhook.getHeadersList()
                .stream()
                .collect(Collectors.toMap(THeader::getName, THeader::getValue));
        return config;
    }

    public TWebhookType toProto() {
        return TWebhookType.newBuilder()
                .setUrl(Nullables.orEmpty(url))
                .setTemplate(Nullables.orEmpty(bodyTemplate))
                .addAllHeaders(Nullables.orEmpty(headers)
                        .entrySet()
                        .stream()
                        .map(entry -> THeader.newBuilder()
                                .setName(entry.getKey())
                                .setValue(entry.getValue())
                                .build())
                        .collect(Collectors.toList()))
                .build();
    }
}
