package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.solomon.alert.protobuf.notification.TYaChatsType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Nikita Minin
 */
@ApiModel(value = "yaChats")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class YaChatsMethod {

    @ApiModelProperty(value = "Staff login",
        example = "alexlovkov")
    public String login;

    @ApiModelProperty(value = "Id of the group chat",
        example = "0/0/032dd1f7-f7a9-4c2f-bb03-730068f2c702")
    public String groupId;

    @ApiModelProperty(value = "Mustache template for yaChats. It's optional parameter",
        example = "Everything is broken : {{status.code}}!")
    public String textTemplate;

    static YaChatsMethod fromProto(@Nonnull TYaChatsType yaChats) {
        YaChatsMethod yaChatsMethod = new YaChatsMethod();
        yaChatsMethod.login = yaChats.getLogin();
        yaChatsMethod.textTemplate = yaChats.getTextTemplate();
        yaChatsMethod.groupId = yaChats.getGroupId();
        return yaChatsMethod;
    }

    public TYaChatsType toProto() {
        TYaChatsType.Builder builder = TYaChatsType.newBuilder()
            .setTextTemplate(Nullables.orEmpty(textTemplate))
            .setLogin(Nullables.orEmpty(login));

        if (Strings.isNotEmpty(login)) {
            return builder.setLogin(login).build();
        }

        return builder.setGroupId(groupId).build();
    }
}
