package ru.yandex.solomon.alert.gateway.endpoint;

import java.util.concurrent.CompletableFuture;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.alert.client.grpc.AlertTemplateClient;
import ru.yandex.solomon.alert.gateway.dto.alert.AlertTemplateDeployDto;
import ru.yandex.solomon.alert.gateway.dto.alert.AlertTemplateDto;
import ru.yandex.solomon.alert.gateway.dto.alert.AlertTemplateList;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationRequest;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.TemplateDeployPolicy;
import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthorizationObject;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.SolomonTeam;
import ru.yandex.solomon.auth.exceptions.AuthorizationException;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.auth.roles.Permission;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
@Deprecated
@Api(tags = {"alerting"})
@RestController
@RequestMapping(path = "/api/v2/alert-templates", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AlertTemplateDeprecatedController {

    private static final String SERVICE_PROVIDER_HEADER = "X-Service-Provider";
    private final AlertTemplateClient alertTemplateClient;
    private final Authorizer authorizer;

    public AlertTemplateDeprecatedController(AlertTemplateClient alertTemplateClient, Authorizer authorizer) {
        this.alertTemplateClient = alertTemplateClient;
        this.authorizer = authorizer;
    }

    @Deprecated
    @ApiOperation(value = "Create alert template version", response = AlertTemplateDto.class)
    @PostMapping("/{templateId}")
    CompletableFuture<AlertTemplateDto> create(
            @RequireAuth AuthSubject subject,
            @RequestBody AlertTemplateDto template,
            @RequestHeader(value = SERVICE_PROVIDER_HEADER, required = false, defaultValue = "") String serviceProviderId)
    {
        CreateAlertTemplateRequest request = CreateAlertTemplateRequest.newBuilder()
                .setAlertTemplate(template.toProto())
                .build();

        return authorize(subject, serviceProviderId, Permission.ALERT_TEMPLATE_MANAGEMENT)
                .thenCompose(account -> alertTemplateClient.create(request)
                .thenApply(response -> AlertTemplateDto.fromProto(response.getAlertTemplate())));
    }

    @Deprecated
    @ApiOperation(value = "Get published version of alert template by id", response = AlertTemplateDto.class)
    @GetMapping("/{templateId}")
    CompletableFuture<AlertTemplateDto> getAlertTemplateLastVersion(
            @RequireAuth AuthSubject subject,
            @PathVariable("templateId") String templateId)
    {
        ReadAlertTemplateRequest request = ReadAlertTemplateRequest.newBuilder()
                .setTemplateId(templateId)
                .setTemplateVersionTag("")
                .build();

        return alertTemplateClient.read(request)
                .thenApply(response -> AlertTemplateDto.fromProto(response.getAlertTemplate()));
    }

    @Deprecated
    @ApiOperation(value = "Get alert template version by id and version", response = AlertTemplateDto.class)
    @GetMapping("/{templateId}/versions/{templateVersionTag}")
    CompletableFuture<AlertTemplateDto> getAlertTemplate(
            @RequireAuth AuthSubject subject,
            @PathVariable("templateId") String templateId,
            @PathVariable("templateVersionTag") String templateVersionTag)
    {
        ReadAlertTemplateRequest request = ReadAlertTemplateRequest.newBuilder()
                .setTemplateId(templateId)
                .setTemplateVersionTag(templateVersionTag)
                .build();

        return alertTemplateClient.read(request)
                .thenApply(response -> AlertTemplateDto.fromProto(response.getAlertTemplate()));
    }

    @Deprecated
    @ApiOperation(value = "Publish alert template version.", response = AlertTemplateDto.class)
    @PostMapping("/{templateId}/versions/{templateVersionTag}/publish")
    CompletableFuture<AlertTemplateDto> publish(
            @RequireAuth AuthSubject subject,
            @PathVariable("templateId") String templateId,
            @PathVariable("templateVersionTag") String templateVersionTag,
            @RequestHeader(value = SERVICE_PROVIDER_HEADER, required = false, defaultValue = "") String serviceProviderId)
    {
        if (!SolomonTeam.isMember(subject)) {
            return CompletableFuture.failedFuture(new AuthorizationException("Haven't permission"));
        }
        PublishAlertTemplateRequest request = PublishAlertTemplateRequest.newBuilder()
                .setTemplateId(templateId)
                .setTemplateVersionTag(templateVersionTag)
                .build();

        return authorize(subject, serviceProviderId, Permission.ALERT_TEMPLATE_MANAGEMENT)
                .thenCompose(account -> alertTemplateClient.publish(request)
                        .thenApply(response -> AlertTemplateDto.fromProto(response.getAlertTemplate())));
    }

    @Deprecated
    @ResponseStatus(HttpStatus.NO_CONTENT)
    @ApiOperation(value = "Delete alert template publication.")
    @PostMapping("/{templateId}/unpublish")
    CompletableFuture<Void> unpublish(
            @RequireAuth AuthSubject subject,
            @PathVariable("templateId") String templateId,
            @RequestHeader(value = SERVICE_PROVIDER_HEADER, required = false, defaultValue = "") String serviceProviderId)
    {
        if (!SolomonTeam.isMember(subject)) {
            return CompletableFuture.failedFuture(new AuthorizationException("Haven't permission"));
        }
        DeleteAlertTemplatePublicationRequest request = DeleteAlertTemplatePublicationRequest.newBuilder()
                .setTemplateId(templateId)
                .build();

        return authorize(subject, serviceProviderId, Permission.ALERT_TEMPLATE_MANAGEMENT)
                .thenCompose(account -> alertTemplateClient.unpublish(request)
                        .thenApply(response -> null));
    }

    @Deprecated
    @ApiOperation(value = "Deploy alert template. Updates template alerts.", response = AlertTemplateDeployDto.class)
    @PostMapping("/{templateId}/versions/{templateVersionTag}/deploy")
    CompletableFuture<AlertTemplateDeployDto> deploy(
            @RequireAuth AuthSubject subject,
            @PathVariable("templateId") String templateId,
            @PathVariable("templateVersionTag") String templateVersionTag,
            @RequestParam(value = "deployPolicy", required = false) TemplateDeployPolicy deployPolicy,
            @RequestHeader(value = SERVICE_PROVIDER_HEADER, required = false, defaultValue = "") String serviceProviderId)
    {
        if (!SolomonTeam.isMember(subject)) {
            return CompletableFuture.failedFuture(new AuthorizationException("Haven't permission"));
        }
        DeployAlertTemplateRequest request = DeployAlertTemplateRequest.newBuilder()
                .setTemplateId(templateId)
                .setTemplateVersionTag(templateVersionTag)
                .setTemplateDeployPolicy(Nullables.orDefault(deployPolicy, TemplateDeployPolicy.TEMPLATE_DEPLOY_POLICY_MANUAL))
                .build();

        return authorize(subject, serviceProviderId, Permission.ALERT_TEMPLATE_MANAGEMENT)
                .thenCompose(account -> alertTemplateClient.deploy(request)
                        .thenApply(AlertTemplateDeployDto::fromProto));
    }

    @Deprecated
    @ApiOperation(value = "Get alert templates", response = AlertTemplateList.class)
    @GetMapping
    CompletableFuture<AlertTemplateList> listAlertTemplate(
            @RequireAuth AuthSubject subject,
            @RequestParam(value = "serviceProviderId", required = false, defaultValue = "") String serviceProviderId,
            @RequestParam(value = "name", required = false, defaultValue = "") String name,
            @RequestParam(value = "pageSize", defaultValue = "100", required = false) int pageSize,
            @RequestParam(value = "pageToken", defaultValue = "", required = false) String pageToken)
    {
        ListAlertTemplateRequest request = ListAlertTemplateRequest.newBuilder()
                .setServiceProviderId(serviceProviderId)
                .setNameFilter(name)
                .setPageToken(pageToken)
                .setPageSize(pageSize)
                .build();

        return alertTemplateClient.list(request)
                .thenApply(AlertTemplateList::fromProto);
    }

    private CompletableFuture<Account> authorize(AuthSubject subject, String serviceProviderId, Permission permission) {
        if (SolomonTeam.isMember(subject)) {
            return CompletableFuture.completedFuture(null);
        }
        return authorizer.authorize(subject, AuthorizationObject.serviceProvider(serviceProviderId, null), permission);
    }

}
