package ru.yandex.solomon.alert.gateway.endpoint;

import java.util.concurrent.CompletableFuture;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.alert.client.TelegramApi;
import ru.yandex.solomon.alert.gateway.dto.TelegramGroupTitlesResponseDto;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesRequest;


/**
 * @author alexlovkov
 **/
@Api(tags = {"alerting"})
@RestController
@RequestMapping(path = "/api/v2/telegram", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TelegramController {

    private final TelegramApi api;

    @Autowired
    public TelegramController(TelegramApi api) {
        this.api = api;
    }

    @ApiOperation(value = "Get telegram group titles", response = TelegramGroupTitlesResponseDto.class)
    @RequestMapping(path = "/groupTitles", method = RequestMethod.GET)
    CompletableFuture<TelegramGroupTitlesResponseDto> getTelegramGroupTitles() {
        return api.getTelegramGroupTitles(TTelegramGroupTitlesRequest.newBuilder().build())
            .thenApply(TelegramGroupTitlesResponseDto::fromModel);
    }
}
