package ru.yandex.solomon.alert.gateway.endpoint;

import java.util.concurrent.CompletableFuture;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.alert.client.YaChatsApi;
import ru.yandex.solomon.alert.gateway.dto.YaChatsGroupsResponseDto;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsRequest;

/**
 * @author Nikita Minin
 */
@Api(tags = {"alerting"})
@RestController
@RequestMapping(path = "/api/v2/yaChats", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class YaChatsController {

    private final YaChatsApi api;

    @Autowired
    public YaChatsController(YaChatsApi api) {
        this.api = api;
    }

    @ApiOperation(value = "Get Yandex Chats group titles and description", response = YaChatsGroupsResponseDto.class)
    @RequestMapping(path = "/groups", method = RequestMethod.GET)
    CompletableFuture<YaChatsGroupsResponseDto> getYaChatsGroups() {
        return api.getYaChatsGroups(TYaChatsGroupsRequest.newBuilder().build())
            .thenApply(YaChatsGroupsResponseDto::fromModel);
    }
}
