package ru.yandex.solomon.alert.gateway.utils;

import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @see <a href="https://clubs.at.yandex-team.ru/ycp/509">Yandex Cloud ID generation guidelines</a>
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class IdGenerator {
    public static final String INTERNAL_PREFIX = "mon";

    public static String generateInternalId() {
        return generateId(INTERNAL_PREFIX);
    }

    public static String generateId(String prefix) {
        Random rnd = ThreadLocalRandom.current();
        byte[] rndBuffer = new byte[11];
        rnd.nextBytes(rndBuffer);
        rndBuffer[0] = (byte) rnd.nextInt(0x20);
        return String.format("%s%17s", prefix, new BigInteger(rndBuffer).toString(32)).replace(' ', '0');
    }
}
