package ru.yandex.solomon.alert.gateway.yasm.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.bolts.collection.Try;
import ru.yandex.solomon.alert.gateway.dto.alert.AlertDto;
import ru.yandex.solomon.alert.protobuf.TAlert;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConvertAlertResultDto {
    public AlertDto alert;
    public Error error;
    public static class Error {
        public String code;
        public String message;
    }

    public static ConvertAlertResultDto fromConversionResult(@Nonnull Try<TAlert> alert) {
        var result = new ConvertAlertResultDto();
        if (alert.isSuccess()) {
            result.alert = AlertDto.fromProto(alert.get());
        } else {
            Throwable t = alert.getThrowable();
            result.error = new Error();
            result.error.code = t.getClass().getSimpleName();
            result.error.message = t.getMessage();
        }
        return result;
    }
}
