package ru.yandex.solomon.alert.gateway.yasm.dto;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.ambry.dto.TagsField;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
@ApiModel("ConvertYasmQueryDto")
public class ConvertYasmQueryDto {

    @ApiModelProperty(value = "Yasm query tags")
    @JsonDeserialize(using = TagsField.Deserializer.class)
    public Map<String, List<String>> tags;

    @ApiModelProperty(value = "Yasm query name")
    public String name;

    @ApiModelProperty(value = "Yasm query host")
    public String host;

    @ApiModelProperty(value = "Yasm query title")
    public String title;

    @ApiModelProperty(value = "Use right axis")
    public Boolean rightAxis;

    @ApiModelProperty(value = "Normalize data")
    public Boolean normalize;
}
