package ru.yandex.solomon.alert.gateway.converter;

import java.io.IOException;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.alert.gateway.yasm.dto.ConvertYasmQueriesDto;
import ru.yandex.solomon.config.protobuf.frontend.MonitoringConfig;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class DashboardYasmQueryConverterTest {

    private DashboardYasmQueryConverter converter;
    private ObjectMapper mapper;

    @Before
    public void setUp() throws Exception {
        converter = new DashboardYasmQueryConverter("yasm_", MonitoringConfig.newBuilder().setBaseUrl("https://monitoring.yandex-team.ru/").build());
        mapper = new ObjectMapper();
    }

    @Test
    public void dataVolume() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"unistat-handlers.push_signals.accepted_values_summ\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"unistat-handlers.push_signals.accepted_values_summ\",\n" +
                "            \"normalize\": false,\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"unistat-fresh.series_count_ammx\",\n" +
                "            \"normalize\": true,\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"counter-instance_tmmv\",\n" +
                "            \"normalize\": true,\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n," +
                "    \"settings\" : {\n" +
                "        \"normalize\": true\n" +
                "    }" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+unistat-handlers.push_signals.accepted_values_summ%0Adelta_to_rate%28%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.push_signals.accepted_values_summ%27%7D%29&q.1.text=%2F%2F+unistat-handlers.push_signals.accepted_values_summ%0A%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.push_signals.accepted_values_summ%27%7D&q.2.text=%2F%2F+unistat-fresh.series_count_ammx%0Adelta_to_rate%28%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-fresh.series_count_ammx%27%7D%29&q.3.text=%2F%2F+counter-instance_tmmv%0Adelta_to_rate%28%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27counter-instance_tmmv%27%7D%29&type=line", url);
    }

    @Test
    public void pushTime() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"quant(unistat-handlers.push_signals.response_time_hgram, 999)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"quant(unistat-handlers.push_signals.response_time_hgram, 95)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"quant(unistat-handlers.push_signals.response_time_hgram, 90)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+quant%28unistat-handlers.push_signals.response_time_hgram%2C+999%29%0Ahistogram_percentile%2899.9%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.push_signals.response_time_hgram%27%7D%29&q.1.text=%2F%2F+quant%28unistat-handlers.push_signals.response_time_hgram%2C+95%29%0Ahistogram_percentile%2895%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.push_signals.response_time_hgram%27%7D%29&q.2.text=%2F%2F+quant%28unistat-handlers.push_signals.response_time_hgram%2C+90%29%0Ahistogram_percentile%2890%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.push_signals.response_time_hgram%27%7D%29&type=line", url);
    }

    @Test
    public void cpu() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"portoinst-cpu_usage_cores_txxx\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"div(portoinst-cpu_usage_cores_tmmv, counter-instance_tmmv)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\",\n" +
                "            \"title\": \"cpu usage(avg)\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"portoinst-cpu_wait_cores_txxx\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"div(portoinst-cpu_wait_cores_tmmv, counter-instance_tmmv)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+portoinst-cpu_usage_cores_txxx%0A%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27portoinst-cpu_usage_cores_txxx%27%7D&q.1.text=%2F%2F+div%28portoinst-cpu_usage_cores_tmmv%2C+counter-instance_tmmv%29%0Aalias%28%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27portoinst-cpu_usage_cores_tmmv%27%7D+%2F+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27counter-instance_tmmv%27%7D%2C+%22cpu+usage%28avg%29%22%29&q.2.text=%2F%2F+portoinst-cpu_wait_cores_txxx%0A%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27portoinst-cpu_wait_cores_txxx%27%7D&q.3.text=%2F%2F+div%28portoinst-cpu_wait_cores_tmmv%2C+counter-instance_tmmv%29%0A%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27portoinst-cpu_wait_cores_tmmv%27%7D+%2F+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27counter-instance_tmmv%27%7D&type=line", url);
    }


    @Test
    public void bytesWritten() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"hsum(unistat-snapshotter.snapshot_size.bytes_hgram)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+hsum%28unistat-snapshotter.snapshot_size.bytes_hgram%29%0Ahistogram_sum%28%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-snapshotter.snapshot_size.bytes_hgram%27%7D%29&type=line", url);
    }

    @Test
    public void memory() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"max(portoinst-anon_limit_usage_perc_hgram)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype!=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"div(portoinst-anon_usage_gb_tmmv, counter-instance_tmmv)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+max%28portoinst-anon_limit_usage_perc_hgram%29%0Ahistogram_percentile%28100%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+hosts%3D%27ASEARCH%27%2C+%27ctype%21%27%3D%27prod%27%2C+signal%3D%27portoinst-anon_limit_usage_perc_hgram%27%7D%29&q.1.text=%2F%2F+div%28portoinst-anon_usage_gb_tmmv%2C+counter-instance_tmmv%29%0A%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27portoinst-anon_usage_gb_tmmv%27%7D+%2F+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27counter-instance_tmmv%27%7D&type=line", url);
    }

    @Test
    public void cleanupTime() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"havg(unistat-fresh.cleanup_time_hgram)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+havg%28unistat-fresh.cleanup_time_hgram%29%0Ahistogram_avg%28%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-fresh.cleanup_time_hgram%27%7D%29&type=line", url);
    }

    @Test
    public void fetchLabels() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"quant(unistat-handlers.fetch_hosts.response_time_hgram, max)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"quant(unistat-handlers.list_all_signals.response_time_hgram, max)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\",\n" +
                "            \"rightAxis\": true" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+quant%28unistat-handlers.fetch_hosts.response_time_hgram%2C+max%29%0Ahistogram_percentile%28100%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.fetch_hosts.response_time_hgram%27%7D%29&q.1.text=%2F%2F+quant%28unistat-handlers.list_all_signals.response_time_hgram%2C+max%29%0Ahistogram_percentile%28100%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-handlers.list_all_signals.response_time_hgram%27%7D%29&q.1.axis=r&type=line", url);
    }

    @Test
    public void pushQueues() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"max(unistat-middle_push_queue_size_xhhh)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n," +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"max(unistat-requester_push_queue_size_xhhh)\",\n" +
                "            \"tags\": \"itype=yasmtsdb;ctype=prod\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+max%28unistat-middle_push_queue_size_xhhh%29%0Ahistogram_percentile%28100%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-middle_push_queue_size_xhhh%27%7D%29&q.1.text=%2F%2F+max%28unistat-requester_push_queue_size_xhhh%29%0Ahistogram_percentile%28100%2C+%27%27%2C+%7Bproject%3D%27yasm_yasmtsdb%27%2C+ctype%3D%27prod%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27unistat-requester_push_queue_size_xhhh%27%7D%29&type=line", url);
    }


    @Test
    public void otherParams() throws IOException {
        String json = "{\n" +
                "    \"signals\" : [\n" +
                "        {\n" +
                "            \"host\": \"ASEARCH\",\n" +
                "            \"name\": \"modules-unistat-ugrams_changed_buckets_mmmm\",\n" +
                "            \"tags\": \"itype=yasmtsdb;geo=sas;gencfg=ALL_YASM_PREPRODUCTION_TSDB\",\n" +
                "            \"title\": \"title\"\n" +
                "        }\n" +
                "    ]\n," +
                "    \"settings\" : {\n" +
                "        \"stack\": true,\n" +
                "        \"refresh\": \"60\",\n" +
                "        \"range\": \"1h\",\n" +
                "        \"normalize\": true\n" +
                "    }" +
                "}";

        var request = mapper.readValue(json, ConvertYasmQueriesDto.class);
        var url = converter.prepareUrl(request);
        Assert.assertEquals("https://monitoring.yandex-team.ru/projects/yasm_yasmtsdb/explorer/queries?q.0.text=%2F%2F+modules-unistat-ugrams_changed_buckets_mmmm%0Aalias%28delta_to_rate%28%7Bproject%3D%27yasm_yasmtsdb%27%2C+geo%3D%27sas%27%2C+gencfg%3D%27ALL_YASM_PREPRODUCTION_TSDB%27%2C+hosts%3D%27ASEARCH%27%2C+signal%3D%27modules-unistat-ugrams_changed_buckets_mmmm%27%7D%29%2C+%22title%22%29&type=area&range=1h&refresh=60", url);
    }
}
