package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.List;
import java.util.Map;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Alexey Trushkin
 */
public class CreateAlertsFromTemplateResponseTest {

    @Test
    public void cmdToProto() {
        var response = CreateAlertsFromTemplateResponse.fromProto(ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse.newBuilder()
                .addAllAlerts(List.of(
                        ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse.Alert.newBuilder()
                                .setTemplateId("1")
                                .setAlertId("2")
                                .putAllResourceParameters(Map.of("3", "4"))
                                .build(),
                        ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse.Alert.newBuilder()
                                .setTemplateId("12")
                                .setAlertId("23")
                                .putAllResourceParameters(Map.of("34", "45"))
                                .build()
                ))
                .build());

        assertEquals(2, response.alerts.size());
        assertEquals("2", response.alerts.get(0).alertId);
        assertEquals("1", response.alerts.get(0).templateId);
        assertEquals("{\"3\":\"4\"}", response.alerts.get(0).resourceRow);
        assertEquals("23", response.alerts.get(1).alertId);
        assertEquals("12", response.alerts.get(1).templateId);
        assertEquals("{\"34\":\"45\"}", response.alerts.get(1).resourceRow);
    }
}
