package ru.yandex.solomon.alert.gateway.yasm.dto;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.alert.gateway.converter.DashboardYasmQueryConverter;
import ru.yandex.solomon.alert.gateway.endpoint.YasmController;
import ru.yandex.solomon.auth.fake.AnonymousAuthorizer;
import ru.yandex.solomon.auth.local.AsUserSubject;
import ru.yandex.solomon.config.protobuf.frontend.MonitoringConfig;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmControllerTest {
    private YasmController controller;
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        mapper = new ObjectMapper();
        controller = new YasmController(new AnonymousAuthorizer(), new DashboardYasmQueryConverter("_yasm", MonitoringConfig.getDefaultInstance()));
    }

    @Test
    public void convert() throws IOException {
        ConvertAlertsRequestDto request = mapper.readValue(getFileContent("alerts.json"), ConvertAlertsRequestDto.class);
        var response = join(controller.convert(new AsUserSubject("uranix"), request));
        assertEquals(3, response.converted.size());
        assertNull(response.converted.get(0).error);
        assertNull(response.converted.get(1).error);
        assertNotNull(response.converted.get(2).error);
        System.out.println(response.converted.get(2).error.code + ": " + response.converted.get(2).error.message);
    }

    private String getFileContent(String fileName) throws IOException {
        URL resource = this.getClass().getResource(fileName);
        return Resources.toString(resource, StandardCharsets.UTF_8);
    }
}
