package ru.yandex.solomon.gateway;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.frontend.TGatewayConfig;
import ru.yandex.solomon.main.SpringContexts;
import ru.yandex.solomon.secrets.SecretProviders;

import static ru.yandex.solomon.config.SolomonConfigs.parseConfigWithoutInclude;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class GatewayMainContextTest {

    @Rule
    public Timeout timeout = Timeout.builder()
            .withLookingForStuckThread(true)
            .withTimeout(1, TimeUnit.MINUTES)
            .build();

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "dev/gateway.dev.conf",
                "testing/gateway.conf",
                "prestable/gateway.conf",
                "production/gateway.conf",
                "cloud-preprod/gateway.conf",
                "cloud-prod/gateway.conf",
        };
    }

    @Test
    public void testConfiguration() {
        if (!Files.exists(Path.of(configFile))) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        var config = parseConfigWithoutInclude(configFile, TGatewayConfig.getDefaultInstance());
        Assert.assertNotEquals(TGatewayConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createWeb(GatewayMainContext.class, config, SecretProviders.empty())) {
            Assert.assertEquals(config, ctx.getBean(TGatewayConfig.class));
        }
    }
}
