package ru.yandex.solomon.gateway;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.joda.time.Duration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.cluster.ClusterMapperContext;
import ru.yandex.misc.web.servlet.TltFilter;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.monlib.metrics.webflux.filters.HttpStatsFilter;
import ru.yandex.solomon.alert.gateway.context.AlertingGatewayContext;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.ShardNumIdGeneratorImpl;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.core.conf.watch.SolomonConfWatcher;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.expression.ExpressionMetrics;
import ru.yandex.solomon.gateway.api.ApiContext;
import ru.yandex.solomon.gateway.api.cloud.RequestProducerContext;
import ru.yandex.solomon.gateway.api.cloud.ext.ExternalMonitoringController;
import ru.yandex.solomon.gateway.api.old.data.OldDataApiController;
import ru.yandex.solomon.gateway.api.old.grafana.GrafanaController;
import ru.yandex.solomon.gateway.api.staffOnly.GlobalStaffOnlyController;
import ru.yandex.solomon.gateway.cloud.GatewayCloudContext;
import ru.yandex.solomon.gateway.data.MetricsClientSubjectMetrics;
import ru.yandex.solomon.gateway.entityConverter.EntityConverterContext;
import ru.yandex.solomon.gateway.filters.TracingFilter;
import ru.yandex.solomon.gateway.filters.VersionHeaderFilter;
import ru.yandex.solomon.gateway.inject.spring.AlertingStatusesContext;
import ru.yandex.solomon.gateway.inject.spring.DataClientContext;
import ru.yandex.solomon.gateway.inject.spring.GatewayIdempotentOperationContext;
import ru.yandex.solomon.gateway.inject.spring.GatewaySchedulerContext;
import ru.yandex.solomon.gateway.inject.spring.HealthContext;
import ru.yandex.solomon.gateway.inject.spring.NameResolverContext;
import ru.yandex.solomon.gateway.inject.spring.ProjectManagerClientContext;
import ru.yandex.solomon.gateway.inject.spring.QuotaManagerContext;
import ru.yandex.solomon.gateway.inject.spring.StaffClientContext;
import ru.yandex.solomon.gateway.inject.spring.StubRequestContext;
import ru.yandex.solomon.gateway.operations.deleteMetrics.DeleteMetricsContext;
import ru.yandex.solomon.gateway.push.PushMetricProcessor;
import ru.yandex.solomon.gateway.www.GatewaySubjectInfoWww;
import ru.yandex.solomon.http.filters.BrokenPipeMuteFilter;
import ru.yandex.solomon.http.filters.FixContentTypeHeader;
import ru.yandex.solomon.http.filters.HttpFirewallFilter;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.http.filters.SolomonApiRequestPatternChanger;
import ru.yandex.solomon.labels.intern.InterningLabelAllocator;
import ru.yandex.solomon.metrics.client.MetricsClientContext;
import ru.yandex.solomon.metrics.client.MetricsClientMetrics;
import ru.yandex.solomon.roles.RolesContext;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.staffOnly.BalancerController;
import ru.yandex.solomon.staffOnly.WtdFilterContext;
import ru.yandex.solomon.tracing.TracingContext;
import ru.yandex.solomon.util.net.DefaultNetworkValidator;
import ru.yandex.solomon.util.net.NetworkValidator;
import ru.yandex.solomon.util.time.Deadline;


/**
 * @author Stepan Koltsov
 */
@Import({
        StubRequestContext.class,
        GatewayIdempotentOperationContext.class,
        HealthContext.class,
        GlobalStaffOnlyController.class,
        ExternalMonitoringController.class,
        BalancerController.class,
        WtdFilterContext.class,
        OldDataApiController.class,
        RequestLoggingFilter.class,
        PushMetricProcessor.class,
        HttpFirewallFilter.class,
        BrokenPipeMuteFilter.class,
        VersionHeaderFilter.class,
        HttpStatsFilter.class,
        GrafanaController.class,
        ApiContext.class,
        AlertingGatewayContext.class,
        ClusterMapperContext.class,
        LazyThreadPoolProvider.class,
        GeneralMonitoringContext.class,
        SolomonConfWatcher.class,
        FeatureFlagsContext.class,
        MetricsClientContext.class,
        DataClientContext.class,
        GatewayCloudContext.class,
        RequestProducerContext.class,
        QuotaManagerContext.class,
        TracingFilter.class,
        TracingContext.class,
        ManagementServer.class,
        AlertingStatusesContext.class,
        FixContentTypeHeader.class,
        RolesContext.class,
        StaffClientContext.class,
        EntityConverterContext.class,
        GatewaySubjectInfoWww.class,
        GatewaySchedulerContext.class,
        DeleteMetricsContext.class,
        ProjectManagerClientContext.class,
        NameResolverContext.class,
})
@Configuration
public class GatewayMainContext {

    @Bean
    public TltFilter tltFilter() {
        return new TltFilter(Duration.millis(Deadline.DEFAULT_TIMEOUT_MILLIS - 2_000));
    }

    @Bean
    public NetworkValidator networkValidator() {
        return DefaultNetworkValidator.loadFromClassPath();
    }

    @Bean
    public ShardNumIdGeneratorImpl shardNumIdGenerator(ShardsDao shardsDao, ThreadPoolProvider threads, MetricRegistry registry) {
        var executor = threads.getExecutorService("CpuLowPriority", "ThreadPools");
        var timer = threads.getSchedulerExecutorService();
        return new ShardNumIdGeneratorImpl(shardsDao, executor, timer, registry);
    }

    @Bean
    public ExpressionMetrics expressionMetrics() {
        return ExpressionMetrics.I;
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public LabelAllocator labelAllocator() {
        return new InterningLabelAllocator();
    }

    @Bean
    public SolomonApiRequestPatternChanger solomonApiRequestPatternChanger() {
        return new SolomonApiRequestPatternChanger();
    }

    @Bean
    public MetricsClientMetrics metricsClientMetrics() {
        return new MetricsClientSubjectMetrics();
    }
}
