package ru.yandex.solomon.gateway;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

import ru.yandex.solomon.config.protobuf.http.HttpServerConfig;
import ru.yandex.solomon.main.http.HttpServer;

/**
 * @author Sergey Polovko
 */
@Component
public class ManagementServer implements AutoCloseable {

    private final HttpServer server;

    @Autowired
    public ManagementServer(ApplicationContext applicationContext) {
        var childContext = createChildContext(applicationContext);
        var httpServerConfig = applicationContext.getBean("InternalHttpServerConfig", HttpServerConfig.class);
        this.server = new HttpServer(childContext, httpServerConfig, "InternalHttpServer");
    }

    @Override
    public void close() {
        server.stop().join();
    }

    private static ApplicationContext createChildContext(ApplicationContext applicationContext) {
        var childContext = new AnnotationConfigWebApplicationContext();
        childContext.setParent(applicationContext);
        childContext.setId(applicationContext.getId() + ":management");
        childContext.register(ManagementConfig.class);

        // close child context when the parent context get closed
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext) applicationContext).addApplicationListener(event -> {
                if (event instanceof ContextClosedEvent) {
                    childContext.close();
                }
            });
        }
        childContext.refresh();
        return childContext;
    }
}
