package ru.yandex.solomon.gateway.api;

import java.util.Optional;

import javax.annotation.Nullable;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.conf.db3.ConfigV3DaoContext;
import ru.yandex.solomon.conf.db3.MonitoringDashboardsDao;
import ru.yandex.solomon.conf.db3.ydb.YdbMonitoringDashboardsDao;
import ru.yandex.solomon.config.gateway.TGatewayCloudConfig;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;

/**
 * @author Alexey Trushkin
 */
@Configuration
@Import({
        ConfigV3DaoContext.class,
})
public class ApiDaoContext {

    public static final String MONITORING_DASHBOARD_TABLE = "MonitoringDashboard";
    public static final String CLOUD_DASHBOARD_TABLE = "CloudDashboard";

    private final TableClient tableClient;
    @Nullable
    private final MetricRegistry metricRegistry;
    private final String ydbPath;

    @Autowired
    public ApiDaoContext(
            TableClient tableClient,
            @Qualifier("configKikimrRootPath") String rootSchema,
            @Nullable MetricRegistry metricRegistry)
    {
        this.tableClient = tableClient;
        this.metricRegistry = metricRegistry;
        this.ydbPath = rootSchema + "/" + ConfigV3DaoContext.CONFIG_DIR + "/" + ConfigV3DaoContext.VERSION + "/";
    }

    @Bean
    public MonitoringDashboardsDao monitoringDashboardsDao(
            Optional<TGatewayCloudConfig> gatewayCloudConfigOpt
    ) {
        boolean isCloud = gatewayCloudConfigOpt.isPresent();
        var postfix = isCloud ? CLOUD_DASHBOARD_TABLE : MONITORING_DASHBOARD_TABLE;
        String tablePath = ydbPath + postfix;
        var dao = new YdbMonitoringDashboardsDao(tableClient, tablePath, isCloud);
        return measure(dao, MonitoringDashboardsDao.class);
    }

    private <TDao> TDao measure(TDao dao, Class<TDao> daoClass) {
        return metricRegistry == null ? dao : DaoMetricsProxy.of(dao, daoClass, metricRegistry);
    }
}
