package ru.yandex.solomon.gateway.api.cloud;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.config.gateway.TGatewayCloudConfig;
import ru.yandex.solomon.gateway.cloud.GatewayCloudContext;
import ru.yandex.solomon.gateway.cloud.api.RequestProducerResolver;
import ru.yandex.solomon.gateway.cloud.api.RequestProducerResolverImpl;
import ru.yandex.solomon.gateway.cloud.api.RequestProducerResolverNoConfigured;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.spring.ConditionalOnMissingBean;
import ru.yandex.solomon.util.SolomonEnv;

/**
 * @author Vladimir Gordiychuk
 */
// TODO: drop it after move all cloud code to special module
@Configuration
public class RequestProducerContext {
    private static final Logger logger = LoggerFactory.getLogger(GatewayCloudContext.class);

    @Bean
    @ConditionalOnMissingBean(TGatewayCloudConfig.class)
    public RequestProducerResolver requestProducerResolverNoConfigured() {
        return new RequestProducerResolverNoConfigured();
    }

    @Bean
    @ConditionalOnBean(TGatewayCloudConfig.class)
    public RequestProducerResolver requestProducerResolver(TGatewayCloudConfig config, SecretProvider secrets) {
        Optional<String> key = secrets.getSecret(config.getUiSignatureKey());

        if (SolomonEnv.DEVELOPMENT.isActive() && key.isEmpty()) {
            logger.warn("CloudConfig.UiSignatureKey not configured");
            return new RequestProducerResolverNoConfigured();
        }

        return new RequestProducerResolverImpl(key
                .orElseThrow(() -> new RuntimeException("cannot create RequestProducerResolver without UiSignatureKey")));
    }

}
