package ru.yandex.solomon.gateway.api.cloud.common;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@ResponseStatus(HttpStatus.BAD_REQUEST)
public class ProgramValidationException extends BadRequestException {
    private final PositionRange range;

    public ProgramValidationException(PositionRange range, String message) {
        super((range == PositionRange.UNKNOWN ? "" : "At " + range + ": ") + message);
        this.range = range;
    }

    public PositionRange getRange() {
        return range;
    }
}
