package ru.yandex.solomon.gateway.api.cloud.ext;

import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.monlib.metrics.encode.MetricFormat;
import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.solomon.selfmon.mon.HttpMetricRegistryEncoder;

/**
 * @author Oleg Baryshnikov
 */
@RestController
public class ExternalMonitoringController {

    @RequestMapping({ "/cloudMetrics" })
    public ResponseEntity<byte[]> metrics(
            @RequestParam(value = "format", defaultValue = "UNKNOWN") MetricFormat format,
            @RequestParam(value = "compression", defaultValue = "NONE") CompressionAlg compression,
            ServerHttpRequest request)
    {
        return HttpMetricRegistryEncoder.encode(ExternalMonitoringMetrics.I, request, format, compression);
    }
}
