package ru.yandex.solomon.gateway.api.cloud.priv.v2;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import yandex.cloud.priv.quota.PQ.BatchUpdateQuotaMetricsRequest;
import yandex.cloud.priv.quota.PQ.GetQuotaDefaultRequest;
import yandex.cloud.priv.quota.PQ.GetQuotaDefaultResponse;
import yandex.cloud.priv.quota.PQ.GetQuotaRequest;
import yandex.cloud.priv.quota.PQ.Quota;
import yandex.cloud.priv.quota.PQ.UpdateQuotaMetricRequest;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface QuotaService {

    CompletableFuture<Quota> get(GetQuotaRequest request);

    CompletableFuture<Void> updateMetric(UpdateQuotaMetricRequest request, String updatedBy, Instant updatedAt);

    CompletableFuture<Void> batchUpdateMetrics(BatchUpdateQuotaMetricsRequest request, String updatedBy, Instant updatedAt);

    CompletableFuture<GetQuotaDefaultResponse> getDefault(GetQuotaDefaultRequest request);
}
