package ru.yandex.solomon.gateway.api.cloud.priv.v2;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;
import yandex.cloud.priv.quota.PQ.BatchUpdateQuotaMetricsRequest;
import yandex.cloud.priv.quota.PQ.GetQuotaDefaultRequest;
import yandex.cloud.priv.quota.PQ.GetQuotaRequest;
import yandex.cloud.priv.quota.PQ.MetricLimit;
import yandex.cloud.priv.quota.PQ.UpdateQuotaMetricRequest;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class Validators {

    public static void validate(GetQuotaRequest request) {
        // nothing to validate
    }

    public static void validate(UpdateQuotaMetricRequest request) {
        validateMetricLimit(request.getMetric());
    }

    public static void validate(BatchUpdateQuotaMetricsRequest request) {
        for (var metric : request.getMetricsList()) {
            validateMetricLimit(metric);
        }
    }

    public static void validate(GetQuotaDefaultRequest request) {
        // nothing to validate
    }

    private static void validateMetricLimit(MetricLimit metric) {
        if (StringUtils.isBlank(metric.getName())) {
            throw new BadRequestException("Quota metric name cannot be blank");
        }
    }
}
