package ru.yandex.solomon.gateway.api.cloud.v1;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AlertingServiceException extends RuntimeException {
    private ERequestStatusCode statusCode;

    public AlertingServiceException(ERequestStatusCode statusCode, String message) {
        super(message, null, true, false);
        this.statusCode = statusCode;
    }

    public ERequestStatusCode getStatusCode() {
        return statusCode;
    }
}
