package ru.yandex.solomon.gateway.api.cloud.v1;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.auth.exceptions.AuthenticationException;
import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.core.exceptions.ConflictException;
import ru.yandex.solomon.core.exceptions.GatewayTimeoutException;
import ru.yandex.solomon.core.exceptions.NotFoundException;
import ru.yandex.solomon.core.exceptions.ServiceUnavailableException;
import ru.yandex.solomon.core.exceptions.TooManyRequestsException;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public final class RequestStatusToAlertingException {

    public static void throwIfNotOk(ERequestStatusCode statusCode, Supplier<String> messageFn) {
        switch (statusCode) {
            case OK:
                return;
            case NOT_FOUND:
                throw new NotFoundException(messageFn.get());
            case INVALID_REQUEST:
                throw new BadRequestException(messageFn.get());
            case CONCURRENT_MODIFICATION:
                throw new ConflictException(messageFn.get());
            case NODE_UNAVAILABLE:
            case SHARD_NOT_INITIALIZED:
                throw new ServiceUnavailableException(messageFn.get());
            case DEADLINE_EXCEEDED:
                throw new GatewayTimeoutException(messageFn.get());
            case RESOURCE_EXHAUSTED:
                throw new TooManyRequestsException(messageFn.get());
            case NOT_AUTHORIZED:
                throw new AuthenticationException(messageFn.get());
            default:
                throw new AlertingServiceException(statusCode, messageFn.get());
        }
    }
}
