package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.primitives.Doubles;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TAlertDataSeries;
import ru.yandex.solomon.model.protobuf.Label;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertDataSeries")
@ParametersAreNonnullByDefault
public class AlertDataSeriesDto {
    @ApiModelProperty(
        value = "Series alias",
        position = 0)
    public String alias;

    @ApiModelProperty(
        value = "Series labels",
        position = 1)
    public Map<String, String> labels;

    @ApiModelProperty(
        value = "Series values",
        position = 2)
    public double[] values;

    public static AlertDataSeriesDto fromProto(TAlertDataSeries dataSeries) {
        var dto = new AlertDataSeriesDto();

        dto.alias = dataSeries.getAlias();
        dto.labels = dataSeries.getLabelsList().stream()
            .collect(Collectors.toMap(Label::getKey, Label::getValue));
        dto.values = Doubles.toArray(dataSeries.getValuesList());

        return dto;
    }
}
