package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TNotificationState;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertNotificationStatus")
@ParametersAreNullableByDefault
public class AlertNotificationStatusDto {
    @ApiModelProperty(
        value = "State for each alert's associated channel",
        readOnly = true,
        position = 0)
    public Map<String, NotificationStateDto> stateByChannelId;

    public static AlertNotificationStatusDto fromProto(@Nonnull List<TNotificationState> notificationStates) {
        var dto = new AlertNotificationStatusDto();

        dto.stateByChannelId = notificationStates.stream()
            .collect(Collectors.toMap(
                TNotificationState::getNotificationChannelId,
                NotificationStateDto::fromProto));

        return dto;
    }
}
