package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.primitives.Longs;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TEvaluationStatus;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationResponse;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertSimulationResult")
@ParametersAreNonnullByDefault
public class AlertSimulationDto {
    @ApiModelProperty(
        value = "Simulation grid timestamps in milliseconds",
        position = 0)
    public long[] timestamps;

    @ApiModelProperty(
        value = "List of aggregated series",
        position = 1)
    public List<AlertDataSeriesDto> series;

    public long[] ok;
    public long[] warn;
    public long[] alarm;
    public long[] noData;
    public long[] error;

    public static AlertSimulationDto fromProto(TSimulateEvaluationResponse simulateResponse) {
        var dto = new AlertSimulationDto();

        dto.timestamps = Longs.toArray(simulateResponse.getTimeMillisList());
        dto.series = simulateResponse.getAggregatedSeriesList().stream()
            .map(AlertDataSeriesDto::fromProto)
            .collect(Collectors.toList());

        dto.ok = new long[dto.timestamps.length];
        dto.warn = new long[dto.timestamps.length];
        dto.alarm = new long[dto.timestamps.length];
        dto.noData = new long[dto.timestamps.length];
        dto.error = new long[dto.timestamps.length];

        for (int i = 0; i < simulateResponse.getEvaluatedStatusesCount(); i++) {
            TEvaluationStatus.ECode status = simulateResponse.getEvaluatedStatuses(i);
            dto.ok[i] = status == TEvaluationStatus.ECode.OK ? 1 : 0;
            dto.warn[i] = status == TEvaluationStatus.ECode.WARN ? 1 : 0;
            dto.alarm[i] = status == TEvaluationStatus.ECode.ALARM ? 1 : 0;
            dto.noData[i] = status == TEvaluationStatus.ECode.NO_DATA ? 1 : 0;
            dto.error[i] = status == TEvaluationStatus.ECode.ERROR ? 1 : 0;
        }

        return dto;
    }
}
