package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.EAlertState;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum AlertState {
    UNKNOWN,
    ACTIVE,
    MUTED,
    DELETED,
    ;

    public static AlertState fromProto(EAlertState state) {
        switch (state) {
            case ACTIVE:
                return ACTIVE;
            case MUTED:
                return MUTED;
            case DELETED:
                return DELETED;
            default:
                return UNKNOWN;
        }
    }

    public EAlertState toProto() {
        switch (this) {
            case DELETED:
                return EAlertState.DELETED;
            case MUTED:
                return EAlertState.MUTED;
            case ACTIVE:
                return EAlertState.ACTIVE;
            default:
                return EAlertState.UNRECOGNIZED;
        }
    }
}
