package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TEvaluationState;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertStatus")
@ParametersAreNullableByDefault
public class AlertStatusDto {
    @ApiModelProperty(
        value = "Previous alert evaluation status",
        readOnly = true,
        position = 0)
    public EvaluationStatusDto previousStatus;

    @ApiModelProperty(
        value = "Current alert evaluation status",
        readOnly = true,
        position = 1)
    public EvaluationStatusDto currentStatus;

    @ApiModelProperty(
        value = "Alert's last evaluation time",
        readOnly = true,
        dataType = "ISO-8601",
        position = 2)
    public String lastEvaluation;

    @ApiModelProperty(
        value = "Alert's last status change time",
        readOnly = true,
        dataType = "ISO-8601",
        position = 3)
    public String lastStatusChange;

    public static AlertStatusDto fromProto(@Nonnull TEvaluationState evaluationState) {
        var dto = new AlertStatusDto();

        if (evaluationState.getLatestEvalMillis() > 0) {
            dto.previousStatus = EvaluationStatusDto.fromProto(evaluationState.getPreviousStatus());
            dto.currentStatus = EvaluationStatusDto.fromProto(evaluationState.getStatus());
            dto.lastEvaluation = Instant.ofEpochMilli(evaluationState.getLatestEvalMillis()).toString();
            dto.lastStatusChange = Instant.ofEpochMilli(evaluationState.getSinceMillis()).toString();
        }

        return dto;
    }
}
