package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.EAlertType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum AlertType {
    UNKNOWN,
    THRESHOLD,
    ;

    public static AlertType fromProto(EAlertType alertType) {
        switch (alertType) {
            case THRESHOLD:
                return THRESHOLD;
            default:
                return UNKNOWN;
        }
    }

    public EAlertType toProto() {
        switch (this) {
            case THRESHOLD:
                return EAlertType.THRESHOLD;
            default:
                return EAlertType.UNRECOGNIZED;
        }
    }
}
