package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.gateway.dto.alert.AlertFromTemplateDto;
import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.TThreshold;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertType")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlertTypeDto {
    @ApiModelProperty(
        value = "Threshold alert configuration",
        position = 0)
    public ThresholdAlertDto thresholdAlert;

    @ApiModelProperty(
            value = "Alert from template configuration",
            position = 1)
    public AlertFromTemplateDto alertFromTemplate;

    @Nonnull
    public static AlertTypeDto fromProto(@Nonnull TAlert alert) {
        switch (alert.getTypeCase()) {
            case THRESHOLD:
                return fromProto(alert.getThreshold());
            case ALERT_FROM_TEMPLATE: {
                var ret = new AlertTypeDto();
                ret.alertFromTemplate = AlertFromTemplateDto.fromProto(alert);
                return ret;
            }
            default:
                throw new UnsupportedOperationException("Unsupported alert type: " + alert.getTypeCase());
        }
    }

    @Nonnull
    private static AlertTypeDto fromProto(@Nonnull TThreshold threshold) {
        var ret = new AlertTypeDto();
        ret.thresholdAlert = ThresholdAlertDto.fromProto(threshold);
        return ret;
    }

    public void addToProto(@Nonnull TAlert.Builder builder, String cloudId, String folderId) {
        validate();

        if (thresholdAlert != null) {
            thresholdAlert.addToProto(builder, cloudId, folderId);
        } else if (alertFromTemplate != null) {
            builder.setAlertFromTemplate(alertFromTemplate.toProto());
        }
    }

    private void validate() {
        if (thresholdAlert == null && alertFromTemplate == null) {
            throw new BadRequestException("Alert type is not set");
        }
    }
}
