package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AssociatedChannel")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AssociatedChannelDto {
    @ApiModelProperty(
        value = "Associated channel id",
        required = true,
        position = 0)
    public String id;

    @ApiModelProperty(
        value = "Notifications config for this channel",
        position = 1)
    public ChannelConfigDto config;

    public static AssociatedChannelDto of(@Nonnull String id, @Nonnull ChannelConfigDto config) {
        var dto = new AssociatedChannelDto();

        dto.id = id;
        dto.config = config;

        return dto;
    }
}
