package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.MetricKey;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("ChannelStatusesHistory")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNullableByDefault
public class ChannelStatusesHistoryDto {
    @ApiModelProperty(
        value = "Time stamps as milliseconds since UTC epoch",
        position = 0)
    public long[] timestamps;

    @ApiModelProperty(
        value = "Count of messages with corresponding status since previous timestamp",
        position = 1)
    public Map<String, long[]> statuses;

    private ChannelStatusesHistoryDto(long[] timestamps, Map<String,long[]> statuses) {
        this.timestamps = timestamps;
        this.statuses = statuses;
    }

    public static ChannelStatusesHistoryDto create(@Nonnull List<Metric<MetricKey>> metrics) {

        var result = StatusMergingSupport.mergeFrom(metrics);

        return new ChannelStatusesHistoryDto(result.timestamps, result.statuses);
    }

}

