package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.ECompare;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum Comparison {
    UNKNOWN,
    EQ,
    NE,
    GT,
    LT,
    GTE,
    LTE,
    ;

    public static Comparison fromProto(ECompare comparison) {
        switch (comparison) {
            case LTE:
                return LTE;
            case LT:
                return LT;
            case GT:
                return GT;
            case GTE:
                return GTE;
            case EQ:
                return EQ;
            case NE:
                return NE;
            default:
                return UNKNOWN;
        }
    }

    public ECompare toProto() {
        switch (this) {
            case LTE:
                return ECompare.LTE;
            case LT:
                return ECompare.LT;
            case GT:
                return ECompare.GT;
            case GTE:
                return ECompare.GTE;
            case EQ:
                return ECompare.EQ;
            case NE:
                return ECompare.NE;
            default:
                return ECompare.UNRECOGNIZED;
        }
    }
}
