package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudEmailType;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("EmailChannelSettings")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EmailChannelSettingsDto {
    @ApiModelProperty(
        value = "List of recipient's IAM ids",
        required = true,
        position = 10)
    public List<String> recipientIds;

    public static EmailChannelSettingsDto fromProto(@Nonnull TCloudEmailType cloudEmail) {
        var dto = new EmailChannelSettingsDto();

        dto.recipientIds = cloudEmail.getRecipientsList();

        return dto;
    }

    public TCloudEmailType toProto() {
        validate();

        return TCloudEmailType.newBuilder()
            .addAllRecipients(recipientIds)
            .build();
    }

    private void validate() {
        Validators.checkPresent(recipientIds, "recipientIds");
        Validators.checkNonEmpty(recipientIds, "recipientIds");
    }
}
