package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;

/**
 * @author Ivan Tsybulin
 */

@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EntityDto {
    @ApiModelProperty(
        value = "Object identifier",
        readOnly = true,
        required = true,
        dataType = "java.util.UUID",
        position = 0)
    public String id;

    @ApiModelProperty(
        value = "Folder id of this object",
        readOnly = true,
        required = true,
        dataType = "java.util.UUID",
        position = 1)
    public String folderId;

    @ApiModelProperty(
        value = "Human-readable name of the object",
        required = true,
        example = "My object",
        position = 2)
    public String name;

    @ApiModelProperty(
        value = "Version of the object",
        position = 3)
    public Integer version;

    @ApiModelProperty(
        value = "User who created the object",
        readOnly = true,
        position = 4)
    public String createdBy;

    @ApiModelProperty(
        value = "Creation time of the object",
        readOnly = true,
        dataType = "ISO-8601",
        position = 5)
    public String createdAt;

    @ApiModelProperty(
        value = "User who updated the object last time",
        readOnly = true,
        position = 6)
    public String updatedBy;

    @ApiModelProperty(
        value = "Last update time of the object",
        readOnly = true,
        dataType = "ISO-8601",
        position = 7)
    public String updatedAt;

    public void fillCreatedNow(String folderId, String user) {
        String now = Instant.now().toString();
        this.id = "";
        this.folderId = folderId;
        this.createdBy = user;
        this.createdAt = now;
        this.updatedBy = user;
        this.updatedAt = now;
    }

    public void fillUpdatedNow(String folderId, String alertId, String user) {
        String now = Instant.now().toString();
        this.id = alertId;
        this.folderId = folderId;
        this.updatedBy = user;
        this.updatedAt = now;
    }

    public static void fillFromProto(@Nonnull EntityDto dto, @Nonnull TAlert alert) {
        dto.id = alert.getId();
        dto.folderId = alert.getFolderId();
        dto.name = alert.getName();
        dto.version = alert.getVersion();
        dto.createdBy = alert.getCreatedBy();
        dto.createdAt = Instant.ofEpochMilli(alert.getCreatedAt()).toString();
        dto.updatedBy = alert.getUpdatedBy();
        dto.updatedAt = Instant.ofEpochMilli(alert.getUpdatedAt()).toString();
    }

    public static void fillFromProto(@Nonnull EntityDto dto, @Nonnull TNotification notification) {
        dto.id = notification.getId();
        dto.folderId = notification.getFolderId();
        dto.name = notification.getName();
        dto.version = notification.getVersion();
        dto.createdBy = notification.getCreatedBy();
        dto.createdAt = Instant.ofEpochMilli(notification.getCreatedAt()).toString();
        dto.updatedBy = notification.getUpdatedBy();
        dto.updatedAt = Instant.ofEpochMilli(notification.getUpdatedAt()).toString();
    }
}
