package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TEvaluationStatus;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("EvaluationStatus")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EvaluationStatusDto {
    public enum Code {
        UNKNOWN,
        OK,
        WARN,
        ALARM,
        NO_DATA,
        ERROR,
        ;

        public static Code fromProto(@Nonnull TEvaluationStatus.ECode code) {
            switch (code) {
                case ALARM:
                    return ALARM;
                case OK:
                    return OK;
                case ERROR:
                    return ERROR;
                case NO_DATA:
                    return NO_DATA;
                case WARN:
                    return WARN;
                default:
                    return UNKNOWN;
            }
        }

        public TEvaluationStatus.ECode toProto() {
            validate();

            switch (this) {
                case ALARM:
                    return TEvaluationStatus.ECode.ALARM;
                case OK:
                    return TEvaluationStatus.ECode.OK;
                case ERROR:
                    return TEvaluationStatus.ECode.ERROR;
                case NO_DATA:
                    return TEvaluationStatus.ECode.NO_DATA;
                case WARN:
                    return TEvaluationStatus.ECode.WARN;
                default:
                    return TEvaluationStatus.ECode.UNRECOGNIZED;
            }
        }

        private void validate() {
            if (this == UNKNOWN) {
                throw new BadRequestException("Invalid value for status code: " + this);
            }
        }
    }

    @ApiModelProperty(
        value = "Evaluation status result",
        readOnly = true)
    public Code code;

    @ApiModelProperty(
        value = "Evaluated annotations",
        readOnly = true)
    public Map<String, String> annotations;

    public static EvaluationStatusDto fromProto(@Nonnull TEvaluationStatus status) {
        var dto = new EvaluationStatusDto();

        dto.annotations = status.getAnnotationsMap();
        dto.code = Code.fromProto(status.getCode());

        return dto;
    }
}
