package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TEvaluationStats;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsResponse;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("FolderStats")
@ParametersAreNullableByDefault
public class FolderStatsDto {
    @ApiModelProperty(
        value = "Total alert count in folder",
        readOnly = true,
        position = 0)
    public int totalAlertCount;

    @ApiModelProperty(
        value = "Alert count in OK state",
        readOnly = true,
        position = 1)
    public long okCount;

    @ApiModelProperty(
        value = "Alert count in WARN state",
        readOnly = true,
        position = 2)
    public long warnCount;

    @ApiModelProperty(
        value = "Alert count in ALARM state",
        readOnly = true,
        position = 3)
    public long alarmCount;

    @ApiModelProperty(
        value = "Alert count in ERROR state",
        readOnly = true,
        position = 4)
    public long errorCount;

    @ApiModelProperty(
        value = "Alert count in NO_DATA state",
        readOnly = true,
        position = 5)
    public long noDataCount;

    public static FolderStatsDto fromProto(@Nonnull TReadProjectStatsResponse response) {
        FolderStatsDto dto = new FolderStatsDto();

        dto.totalAlertCount = response.getAlertsCount();
        TEvaluationStats evaluationStats = response.getEvaluationStats();

        dto.okCount = evaluationStats.getCountOk();
        dto.warnCount = evaluationStats.getCountWarn();
        dto.alarmCount = evaluationStats.getCountAlarm();
        dto.errorCount = evaluationStats.getCountError();
        dto.noDataCount = evaluationStats.getCountNoData();

        return dto;
    }
}
