package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.label.LabelConf;
import ru.yandex.solomon.metrics.client.LabelNamesResponse;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class LabelKeysResponseDto {

    @JsonProperty
    private List<String> keys;

    @Nonnull
    public static LabelKeysResponseDto fromModel(@Nonnull LabelNamesResponse model) {
        LabelKeysResponseDto dto = new LabelKeysResponseDto();
        ArrayList<String> keys = new ArrayList<>(model.getNames());
        keys.sort(LabelConf.getPartialSorterComparator());
        dto.keys = keys;
        return dto;
    }
}
