package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.labels.validate.LabelValidationFilter;
import ru.yandex.solomon.labels.protobuf.LabelValidationFilterConverter;
import ru.yandex.solomon.metrics.client.LabelValuesResponse;
import ru.yandex.solomon.util.labelStats.LabelStats;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;
import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class LabelValuesResponseDto {

    @JsonProperty
    private List<String> values;
    @JsonProperty
    private boolean absent;
    @JsonProperty
    private boolean truncated;

    @Nonnull
    public static LabelValuesResponseDto fromModel(
        @Nonnull LabelValuesResponse model,
        @Nonnull ru.yandex.solomon.metabase.protobuf.LabelValidationFilter protoValidationFilter)
    {
        LabelValuesStats labelValuesStats = model.getLabelValuesStats();

        if (labelValuesStats.getStatsByLabelKey().isEmpty()) {
            return new LabelValuesResponseDto();
        }

        LabelStats labelStats = labelValuesStats.getStatsByLabelKey().values().iterator().next();

        boolean absent = labelStats.getCount() < labelValuesStats.getMetricsCount();

        LabelValidationFilter validationFilter =
            LabelValidationFilterConverter.protoToFilter(protoValidationFilter);

        List<String> filteredAndSortedValues =
            labelStats.getValues().stream()
                .filter(validationFilter::filterValue)
                .sorted(TextWithNumbersComparator.instance)
                .collect(Collectors.toList());

        LabelValuesResponseDto dto = new LabelValuesResponseDto();
        dto.values = filteredAndSortedValues;
        dto.absent = absent;
        dto.truncated = labelStats.isTruncated();
        return dto;
    }
}
