package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.function.BiConsumer;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertsPage")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListAlert extends TokenBasePage<AlertListItemDto> {

    public static ListAlert fromProto(@Nonnull TListAlertResponse listAlertResponse,
                                      @Nonnull BiConsumer<String, NotificationChannelPropertiesDto> resolver) {
        var dto = new ListAlert();

        dto.nextPageToken = listAlertResponse.getNextPageToken();
        dto.items = listAlertResponse.getAlertsList().stream()
            .map(alertListItemProto -> AlertListItemDto.fromProto(alertListItemProto, resolver))
            .collect(Collectors.toList());

        return dto;
    }
}
