package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("NotificationChannelsPage")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListNotification extends TokenBasePage<NotificationChannelPropertiesWithRecipientsDto> {

    public static ListNotification fromProto(@Nonnull TListNotificationsResponse listNotificationsResponse) {
        var dto = new ListNotification();

        dto.nextPageToken = listNotificationsResponse.getNextPageToken();
        dto.items = listNotificationsResponse.getNotificationList().stream()
            .map(NotificationChannelPropertiesWithRecipientsDto::fromProto)
            .collect(Collectors.toList());

        return dto;
    }
}
