package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TNotification;
import ru.yandex.solomon.alert.protobuf.notification.TNotificationDetails;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("NotificationChannelProperties")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotificationChannelPropertiesDto {
    @ApiModelProperty(
        value = "Channel identifier",
        readOnly = true,
        position = 0)
    public String id;

    @ApiModelProperty(
        value = "Human readable name",
        readOnly = true,
        position = 1)
    public String name;

    @ApiModelProperty(
        value = "Channel transport type",
        readOnly = true,
        position = 2)
    public TransportType type;

    public static void fillFromProto(@Nonnull NotificationChannelPropertiesDto dto, @Nonnull TNotification notification) {
        dto.id = notification.getId();
        dto.name = notification.getName();
        dto.type = TransportType.fromProto(notification.getTypeCase());
    }

    public static void fillFromProto(@Nonnull NotificationChannelPropertiesDto dto, @Nonnull TNotificationDetails notificationDetails) {
        dto.id = notificationDetails.getNotificationId();
        dto.name = notificationDetails.getName();
        dto.type = TransportType.fromProto(notificationDetails.getType());
    }

    public static void fillNotFound(@Nonnull NotificationChannelPropertiesDto dto, @Nonnull String channelId) {
        dto.id = channelId;
        dto.type = TransportType.NOT_FOUND;
    }
}
