package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("NotificationChannelPropertiesWithConfig")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotificationChannelPropertiesWithConfigDto extends NotificationChannelPropertiesDto {
    @ApiModelProperty(
        value = "Notifications config for this channel",
        position = 10)
    public ChannelConfigDto config;

    public NotificationChannelPropertiesWithConfigDto setConfig(ChannelConfigDto channelConfig) {
        this.config = channelConfig;
        return this;
    }
}
