package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TNotification;
import ru.yandex.solomon.alert.protobuf.notification.TNotificationDetails;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("NotificationChannelPropertiesWithRecipients")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotificationChannelPropertiesWithRecipientsDto extends NotificationChannelPropertiesDto {
    @ApiModelProperty(
        value = "Recipients for this channel",
        readOnly = true,
        position = 0)
    public List<String> recipients;

    private static List<String> recipientsFromNotification(@Nonnull TNotification notification) {
        return switch (notification.getTypeCase()) {
            case CLOUDEMAIL -> notification.getCloudEmail().getRecipientsList();
            case CLOUDSMS -> notification.getCloudSms().getRecipientsList();
            case CLOUDPUSH -> notification.getCloudPush().getRecipientsList();
            default -> null;
        };
    }

    public static NotificationChannelPropertiesWithRecipientsDto fromProto(@Nonnull TNotification notification) {
        var dto = new NotificationChannelPropertiesWithRecipientsDto();

        NotificationChannelPropertiesDto.fillFromProto(dto, notification);

        dto.recipients = recipientsFromNotification(notification);

        return dto;
    }

    public static NotificationChannelPropertiesWithRecipientsDto fromProto(@Nonnull TNotificationDetails notificationDetails) {
        var dto = new NotificationChannelPropertiesWithRecipientsDto();

        NotificationChannelPropertiesDto.fillFromProto(dto, notificationDetails);

        dto.recipients = notificationDetails.getRecipientsList();

        return dto;
    }

    public static NotificationChannelPropertiesWithRecipientsDto notFound(@Nonnull String channelId) {
        var dto = new NotificationChannelPropertiesWithRecipientsDto();

        NotificationChannelPropertiesDto.fillNotFound(dto, channelId);

        return dto;
    }
}
